% Keithley KPCI-3108
% data is logged to memory and to a disk file, 
% four triggers are issued, and X seconds of data 
% are collected for each trigger at a specified 
% sampling rate. You can run this example
% by typing KIAI_DataLog at the MATLAB command line.

% 1. create device object
    ai = analoginput('keithley',0); 
% 2. Add channels
    ch = addchannel(ai,0:1);
    set(ch,'InputRange',[-10 10])
% 3. Configure property values
        % set sampling parameters
            sfreq = 10000;
            duration =1; % sec per trigger
            
    set(ai,'SampleRate',sfreq)
    ActualRate = get(ai,'SampleRate');
    set(ai,'SamplesPerTrigger',duration*ActualRate)
    set(ai,'TriggerRepeat',1) %repeat after initial trigger
    set(ai,'LogFileName','KIAI_data_01.daq')
    set(ai,'LoggingMode','Disk&Memory')

% 4.Acquire data - Start ai, wait for ai to stop
%   running, and extract all the data stored in the log file as
%   sample-time pairs.
    start(ai)
    while strcmp(ai.Running,'On')
    end
    [data,time] = daqread('KIAI_data_01.daq');
    
    subplot(211)
    plot(data),legend('Ch0 (V)','Ch1(V)')
    title('Logging and Retrieving Data')
    ylabel('Signal (Volts)'),xlabel('Samples')
    subplot(212)
    plot(time,data(:,1),'r',time,data(:,2),'b')
    legend('Ch0 (V)','Ch1(V)')
    xlabel('Relative Time (seconds)'), ylabel('Signal (Volts)')

% 5. Clean up 
    delete(ai)  %clear the memory
    clear ai     
clear all